* [做项目（多个C++、Java、Go、测开、前端项目）](https://www.programmercarl.com/other/kstar.html)
* [刷算法（两个月高强度学算法）](https://www.programmercarl.com/xunlian/xunlianying.html)
* [背八股（40天挑战高频面试题）](https://www.programmercarl.com/xunlian/bagu.html)


# 657. 机器人能否返回原点

[力扣题目链接](https://leetcode.cn/problems/robot-return-to-origin/)

在二维平面上，有一个机器人从原点 (0, 0) 开始。给出它的移动顺序，判断这个机器人在完成移动后是否在 (0, 0) 处结束。

移动顺序由字符串表示。字符 move[i] 表示其第 i 次移动。机器人的有效动作有 R（右），L（左），U（上）和 D（下）。如果机器人在完成所有动作后返回原点，则返回 true。否则，返回 false。

注意：机器人“面朝”的方向无关紧要。 “R” 将始终使机器人向右移动一次，“L” 将始终向左移动等。此外，假设每次移动机器人的移动幅度相同。

 

示例 1:
* 输入: "UD"
* 输出: true
* 解释：机器人向上移动一次，然后向下移动一次。所有动作都具有相同的幅度，因此它最终回到它开始的原点。因此，我们返回 true。

示例 2:
* 输入: "LL"
* 输出: false
* 解释：机器人向左移动两次。它最终位于原点的左侧，距原点有两次 “移动” 的距离。我们返回 false，因为它在移动结束时没有返回原点。



## 思路

这道题目还是挺简单的，大家不要想复杂了，一波哈希法又一波图论算法之类的。

其实就是，x，y坐标，初始为0，然后：
* if (moves[i] == 'U') y++;
* if (moves[i] == 'D') y--;
* if (moves[i] == 'L') x--;
* if (moves[i] == 'R') x++;

最后判断一下x，y是否回到了(0, 0)位置就可以了。

如图所示：
<img src='https://file1.kamacoder.com/i/algo/657.机器人能否返回原点.png' width=600> </img></div>

C++代码如下：

```CPP
class Solution {
public:
    bool judgeCircle(string moves) {
        int x = 0, y = 0;
        for (int i = 0; i < moves.size(); i++) {
            if (moves[i] == 'U') y++;
            if (moves[i] == 'D') y--;
            if (moves[i] == 'L') x--;
            if (moves[i] == 'R') x++;
        }
        if (x == 0 && y == 0) return true;
        return false;
    }
};
```


## 其他语言版本

### Java

```java
// 时间复杂度：O(n)
// 空间复杂度：如果采用 toCharArray，则是 O（n）;如果使用 charAt，则是 O(1)
class Solution {
    public boolean judgeCircle(String moves) {
        int x = 0;
        int y = 0;
        for (char c : moves.toCharArray()) {
            if (c == 'U') y++;
            if (c == 'D') y--;
            if (c == 'L') x++;
            if (c == 'R') x--;
        }
        return x == 0 && y == 0;
    }
}
```

### Python

```python
# 时间复杂度：O(n)
# 空间复杂度：O(1)
class Solution:
    def judgeCircle(self, moves: str) -> bool:
        x = 0 # 记录当前位置
        y = 0
        for i in range(len(moves)):
            if (moves[i] == 'U'):
                y += 1
            if (moves[i] == 'D'):
                y -= 1
            if (moves[i] == 'L'):
                x += 1
            if (moves[i] == 'R'):
                x -= 1
        return x == 0 and y == 0
```

### Go

```go
func judgeCircle(moves string) bool {
    x := 0
    y := 0
    for i := 0; i < len(moves); i++ {
        if moves[i] == 'U' {
            y++
        }
        if moves[i] == 'D' {
            y--
        }
        if moves[i] == 'L' {
            x++
        }
        if moves[i] == 'R' {
            x--
        }
    }
    return x == 0 && y == 0;
}
```

### JavaScript

```js
// 时间复杂度：O(n)
// 空间复杂度：O(1)
var judgeCircle = function(moves) {
    var x = 0; // 记录当前位置
    var y = 0;
    for (var i = 0; i < moves.length; i++) {
        if (moves[i] == 'U') y++;
        if (moves[i] == 'D') y--;
        if (moves[i] == 'L') x++;
        if (moves[i] == 'R') x--;
    }
    return x == 0 && y == 0;
};
```


### TypeScript

```ts
var judgeCircle = function (moves) {
  let x = 0
  let y = 0
  for (let i = 0; i < moves.length; i++) {
    switch (moves[i]) {
      case 'L': {
        x--
        break
      }
      case 'R': {
        x++
        break
      }
      case 'U': {
        y--
        break
      }
      case 'D': {
        y++
        break
      }
    }
  }
  return x === 0 && y === 0
};
```



